package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskExtensionsDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsTaskActivities;
import gov.va.med.mhv.mrp.data.model.MyGoalsTaskExtensions;
import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

@Component
public class MyGoalTaskConverter implements Converter<MyGoalsTasks, MyGoalTaskDTO> {

	@Autowired
	private MyGoalsTaskActivitiesConverter myGoalsTaskActivitiesConverter;
	
	@Autowired
	private MyGoalsTaskExtensionsConverter myGoalsTaskExtensionsConverter;
	
	@Override
	public MyGoalTaskDTO convert(MyGoalsTasks e) {
		MyGoalTaskDTO dto = new MyGoalTaskDTO();
		
		dto.setCompletedDate(e.getCompletedDate());
		dto.setCompletionType(e.getCompletionType());
		dto.setDescription(e.getDescription());
		dto.setEndDate(e.getEndDate());
		dto.setEndTime(e.getEndTime());
		dto.setGoalExtensionId(e.getMyGoalsExtension().getGoalExtensionId());
		dto.setTaskId(e.getTaskId());
		dto.setStartDate(e.getStartDate());
		dto.setStartTime(e.getStartTime());
		if (e.getStatus()!=null) {
			dto.setStatus(e.getStatus());
		}
		else {
			dto.setStatus(0);
		}
		dto.setTaskName(e.getTaskName());
		dto.setTaskRepetitionCycleType(e.getTaskRepetitionCycleType());
		dto.setTaskSequenceNumber(e.getTaskSequenceNumber());
		dto.setOplock(e.getOplock());
		
		if (e.getMyGoalsTaskActivities() != null) {
			for (MyGoalsTaskActivities activity : e.getMyGoalsTaskActivities()) {
				MyGoalsTaskActivitiesDTO activityDTO = myGoalsTaskActivitiesConverter.convert(activity);
				dto.getMyGoalsTaskActivities().add(activityDTO);
			}
		}
		
		if (e.getMyGoalsTaskExtensions() != null) {
			for (MyGoalsTaskExtensions taskExt : e.getMyGoalsTaskExtensions()) {
				MyGoalsTaskExtensionsDTO extDTO = myGoalsTaskExtensionsConverter.convert(taskExt);
				dto.getMyGoalsTaskExtensions().add(extDTO);
			}
		}
		
		return dto;
	}

}
